{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:36:26 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes,
  WinProcs,
{$ENDIF}
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  MMObj,
  MMDIBCv,
  MMLevel,
  MMConect,
  MMWavIn,
  MMACMDlg,
  MMOscope,
  MMWavOut,
  MMSpectr,
  MMDSPObj,
  MMCstDlg,
  MMWave,
  MMDesign,
  MMHook;

type
  TForm1 = class(TForm)
    Connector: TMMConnector;
    MMLevel1: TMMLevel;
    btnPlay: TButton;
    btnStop: TButton;
    WaveOut: TMMWaveOut;
    OpenDialog: TMMWaveOpenDialog;
    MMDesigner1: TMMDesigner;
    MemoryWave: TMMMemoryWave;
    btnFile: TButton;
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnFileClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  public
    Stream: TMemoryStream;
    procedure PlayFromStream(Stream: TMemoryStream);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

(* this demo shoes you how to play a wave from a stream *)

procedure TForm1.FormCreate(Sender: TObject);
begin
   Stream := TMemoryStream.Create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   Stream.Free;
end;

procedure TForm1.PlayFromStream(Stream: TMemoryStream);
begin
   { this can be any valid stream }

   { LoadFromStream makes a second copy, so you have the data two times in memory  !!! }
   { Sometimes you get a out of memory error while delphi is running.                  }
   { This error occurs not if the IDE is not open,                                     }
   { but you can't test it with the trial version :-)                                  }

   { makes sure there is no other wave in memory }
   MemoryWave.Wave.FreeWave;

   MemoryWave.Wave.LoadFromStream(Stream);
   WaveOut.Start;
end;

procedure TForm1.btnFileClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      Stream.Clear;
      Stream.LoadFromFile(OpenDialog.FileName);

      btnStop.Enabled := (Stream.Size > 0);
      btnPlay.Enabled := (Stream.Size > 0);
   end;
end;

procedure TForm1.btnPlayClick(Sender: TObject);
begin
   PlayFromStream(Stream);
end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
   WaveOut.Close;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
end;


end.
